<?php

/* -----------------------------------------------------------------
 * 	$Id: motoso.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Motoso {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Motoso() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Motoso.de';
        $this->v_module_homepage = 'www.motoso.de';
        $this->v_module_format = 'xml';
        $this->v_module_export_filename = 'motoso.xml';
        $this->v_filename = 'motoso.php';
        $this->v_keyname = 'MOTOSO';
        $this->v_linkname = 'motoso';
        $this->v_delimiter = '|';
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['retail_price'] = number_format((double) $p_products_array['retail_price'], 2, ',', '');
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        if ($p_products_array['retail_price'] != '0,00') {
            $p_products_array['special_price'] = $p_products_array['products_price'];
            $p_products_array['products_price'] = $p_products_array['retail_price'];
        }
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        $p_products_array['products_description'] = no_html($p_products_array['products_description']);
        $p_products_array['products_short_description'] = no_html($p_products_array['products_short_description']);
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_id'] = 'AID';
        $t_csv_fields_array['products_ean'] = 'EAN';
        $t_csv_fields_array['products_name'] = 'Name';
        $t_csv_fields_array['manufacturers_name'] = 'Hersteller';
        $t_csv_fields_array['products_type'] = 'Autotyp';
        $t_csv_fields_array['products_model'] = 'Modell';
        $t_csv_fields_array['products_material'] = 'Material';
        $t_csv_fields_array['products_color'] = 'Farbe';
        $t_csv_fields_array['products_size'] = 'Gr��e';
        $t_csv_fields_array['products_description'] = 'Beschreibung';
        $t_csv_fields_array['products_short_description'] = 'Kurzbeschreibung';
        $t_csv_fields_array['products_image_1'] = 'Bild-URL-1';
        $t_csv_fields_array['products_image_2'] = 'Bild-URL-2';
        $t_csv_fields_array['products_image_3'] = 'Bild-URL-3';
        $t_csv_fields_array['products_image_4'] = 'Bild-URL_4';
        $t_csv_fields_array['products_image_5'] = 'Bild-URL_5';
        $t_csv_fields_array['products_link'] = 'Deeplink';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_shipping_costs'] = 'Versandkosten';
        $t_csv_fields_array['products_categories'] = 'Kategorie';
        $t_csv_fields_array['products_properties_1'] = 'Produkteigenschaften 1';
        $t_csv_fields_array['products_properties_2'] = 'Produkteigenschaften 2';
        $t_csv_fields_array['products_properties_3'] = 'Produkteigenschaften 3';
        $t_csv_fields_array['products_properties_4'] = 'Produkteigenschaften 4';
        $t_csv_fields_array['products_properties_5'] = 'Produkteigenschaften 5';
        $t_csv_fields_array['products_shippingtime'] = 'Verf�gbarkeit';
        return($t_csv_fields_array);
    }

    function create_xml($p_filename = '', $p_output_array = array()) {
        // parameter check
        if (empty($p_filename) || !is_string($p_filename)) {
            return false;
        }
        // needed params
        $t_lang_id = $_SESSION['languages_id'];        // 1
        $t_lang_code = $_SESSION["language_code"];       // de
        $t_lang_name = $_SESSION["language"];            // german
        $t_currency = $_SESSION["currency"];            // EUR
        $t_lastname = $_SESSION["customer_last_name"];
        $t_firstname = $_SESSION["customer_first_name"];
        // read export file into array
        $t_export_file_array = $p_output_array;
        // get header as array
        $t_column_names_array = $t_export_file_array[0];
        // get module name
        $t_file_split_array = explode(".", $p_filename);
        $t_module_name = strtolower($t_file_split_array[0]);
        // xml header and basic information
        $xml_data = '<?xml version="1.0" encoding="ISO-8859-15"?>' . "\n";
        $xml_data .= '<BMECAT version="1.2">' . "\n";
        $xml_data .= '  <HEADER>' . "\n";
        $xml_data .= '    <CATALOG>' . "\n";
        $xml_data .= '      <LANGUAGE>' . strtoupper($t_lang_code) . '</LANGUAGE>' . "\n";
        $xml_data .= '      <CATALOG_ID>1</CATALOG_ID>' . "\n";
        $xml_data .= '      <CATALOG_VERSION>1.0</CATALOG_VERSION>' . "\n";
        $xml_data .= '      <CATALOG_NAME>XML-Export / ' . ucwords($t_module_name) . '</CATALOG_NAME>' . "\n";
        $xml_data .= '    </CATALOG>' . "\n";
        $xml_data .= '    <SUPPLIER>' . "\n";
        $xml_data .= '      <SUPPLIER_NAME>' . ucwords($t_firstname . ' ' . $t_lastname) . '</SUPPLIER_NAME>' . "\n";
        $xml_data .= '    <SUPPLIER>' . "\n";
        $xml_data .= '  <HEADER>' . "\n";
        $xml_data .= '  <T_NEW_CATALOG prev_version="1">' . "\n";
        // get export scheme
        $t_scheme_array = $this->exportScheme();
        // one array for every block of product information
        $t_details_array = array('products_short_description', 'products_description');
        $t_price_array = array('products_price');
        $t_image_array = array('products_image_1', 'products_image_2', 'products_image_3', 'products_image_4', 'products_image_5');
        $t_category_array = array('products_id', 'products_categories');
        // the rest will be "features"
        $t_all_array = array_merge($t_details_array, $t_price_array, $t_image_array, $t_category_array);
        $t_features_array = array();
        foreach ($t_scheme_array as $t_key => $t_value) {
            if (!in_array($t_key, $t_all_array)) {
                $t_features_array[] = $t_key;
            }
        }
        // work every line of product export
        $loop_count = 0;
        foreach ($t_export_file_array as $t_export_line) {
            $t_line_data_array = $t_export_line;
            // means $loop_count > 0
            if (!empty($loop_count)) {
                // products_id
                $t_prod_id = $this->get_data_for_key_id('products_model', $t_scheme_array, $t_line_data_array);
                // article START
                $xml_data .= '    <ARTICLE mode="new">' . "\n";
                $xml_data .= '      <SUPPLIER_AID>' . $t_prod_id . '</SUPPLIER_AID>' . "\n";
                // details
                $t_man_name = $this->get_data_for_key_id('manufacturers_name', $t_scheme_array, $t_line_data_array);
                $t_desc_short = $this->get_data_for_key_id('products_short_description', $t_scheme_array, $t_line_data_array);
                $t_desc_long = $this->get_data_for_key_id('products_description', $t_scheme_array, $t_line_data_array);
                $xml_data .= '      <ARTICLE_DETAILS>' . "\n";
                $xml_data .= '        <MANUFACTURER_NAME>' . $t_man_name . '</MANUFACTURER_NAME>' . "\n";
                $xml_data .= '        <DESCRIPTION_SHORT>' . $t_desc_short . '</DESCRIPTION_SHORT>' . "\n";
                $xml_data .= '        <DESCRIPTION_LONG>' . $t_desc_long . '</DESCRIPTION_LONG>' . "\n";
                $xml_data .= '      </ARTICLE_DETAILS>' . "\n";
                // features
                $xml_data .= '      <ARTICLE_FEATURES>' . "\n";
                foreach ($t_features_array as $t_key) {
                    $t_feat_name = $t_column_names_array[$t_key];
                    $t_feat_value = $this->get_data_for_key_id($t_key, $t_scheme_array, $t_line_data_array);
                    ;
                    $xml_data .= '        <FEATURE>' . "\n";
                    $xml_data .= '          <FNAME>' . $t_feat_name . '</FNAME>' . "\n";
                    $xml_data .= '          <FVALUE>' . $t_feat_value . '</FVALUE>' . "\n";
                    $xml_data .= '        </FEATURE>' . "\n";
                }
                $xml_data .= '      </ARTICLE_FEATURES>' . "\n";
                // order details
                // price
                $t_price = $this->get_data_for_key_id('products_price', $t_scheme_array, $t_line_data_array);
                $xml_data .= '      <ARTICLE_PRICE_DETAILS>' . "\n";
                $xml_data .= '        <ARTICLE_PRICE price_type="gros_list">' . "\n";
                $xml_data .= '          <PRICE_AMOUNT>' . $t_price . '</PRICE_AMOUNT>' . "\n";
                $xml_data .= '          <PRICE_CURRENCY>' . $t_currency . '</PRICE_CURRENCY>' . "\n";
                $xml_data .= '        </ARTICLE_PRICE>' . "\n";
                $xml_data .= '      </ARTICLE_PRICE_DETAILS>' . "\n";
                // images
                $xml_data .= '      <MIME_INFO>' . "\n";
                foreach ($t_image_array as $t_key) {
                    $t_url = $this->get_data_for_key_id($t_key, $t_scheme_array, $t_line_data_array);
                    if (!empty($t_url)) {
                        $t_type_array = explode(".", $t_url);
                        $t_type = $t_type_array[count($t_type_array) - 1];
                        $xml_data .= '        <MIME>' . "\n";
                        $xml_data .= '          <MIME_TYPE>image/' . $t_type . '</MIME_TYPE>' . "\n";
                        $xml_data .= '          <MIME_SOURCE>' . $t_url . '</MIME_SOURCE>' . "\n";
                        $xml_data .= '          <MIME_ORDER>1</MIME_ORDER>' . "\n";
                        $xml_data .= '        </MIME>' . "\n";
                    }
                }
                $xml_data .= '      </MIME_INFO>' . "\n";
                // article END
                $xml_data .= '    </ARTICLE>' . "\n";
                // category
                $t_cat = $this->get_data_for_key_id('products_categories', $t_scheme_array, $t_line_data_array);
                $xml_data .= '    <ARTICLE_TO_CATALOGGROUP_MAP>' . "\n";
                $xml_data .= '      <ART_ID>' . $t_prod_id . '</ART_ID>' . "\n";
                $xml_data .= '      <CATALOG_GROUP_PATH>' . $t_cat . '</CATALOG_GROUP_PATH>' . "\n";
                $xml_data .= '    </ARTICLE_TO_CATALOGGROUP_MAP>' . "\n";
            }
            $loop_count++;
        }
        // end of xml file
        $xml_data .= '  </T_NEW_CATALOG>' . "\n";
        $xml_data .= '</BMECAT>' . "\n";
        // save file with new name
        $t_fp = fopen(DIR_FS_CATALOG . 'export/' . $p_filename, "w");
        fputs($t_fp, $xml_data . "\n");
        fclose($t_fp);
        // all done
        return true;
    }

    function get_arraykey_id($p_key_name, $p_source_array) {
        $array_count = 0;
        foreach ($p_source_array as $t_key => $t_value) {
            if ($t_key == $p_key_name) {
                return $array_count;
            }
            $array_count++;
        }
        return '0';
    }

    function get_data_for_key_id($p_key_name, $p_keys_array, $p_data_array) {
        $t_key_id = $this->get_arraykey_id($p_key_name, $p_keys_array);
        $t_key_value = $p_data_array[$t_key_id];
        return $t_key_value;
    }

}

?>